package com.vf106.tools.activity;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.File;
import androidx.appcompat.app.AppCompatActivity;

import com.kongqw.serialportlibrary.SerialPortManager;
import com.kongqw.serialportlibrary.listener.OnSerialPortDataListener;
import com.vf106.tools.R;
import com.vf106.tools.activity.base.BaseActivity;
import com.vf106.tools.service.SoundService;
import com.vf106.tools.utils.Constants;
import com.vf106.tools.utils.Utils;

/**
 * Temperature Modules
 */
public class TemperatureActivity extends BaseActivity implements View.OnClickListener {
    private Button temperature;
    private String serial = "";
    private TextView tvSerial;
    private SerialPortManager mSerialPortManager;
    private LinearLayout llRight;
    private LinearLayout llWrong;
    private int position;
    private int state;
    private String name;
    @Override
    protected void setContentView() {
        setContentView(R.layout.activity_temperature);
    }

    @Override
    protected void initViews() {
        Intent intent = getIntent();
        position = intent.getIntExtra("position", 0);
        name = intent.getStringExtra("name");
        state = intent.getIntExtra("state", 0);
        temperature = findViewById(R.id.btn_temperature);
        tvSerial = findViewById(R.id.tv_serial);
        mSerialPortManager = new SerialPortManager();
        llRight = findViewById(R.id.ll_right);
        llWrong = findViewById(R.id.ll_wrong);

        mSerialPortManager.openSerialPort(new File("/dev/ttyS9"), 115200);
        mSerialPortManager.startReadThread(485);
        mSerialPortManager.startSendThread();
    }

    @Override
    protected void setTitle() {
        setActionBarTitle("Temperature Modules");
    }

    @Override
    protected void setListener() {
        temperature.setOnClickListener(v -> {
            boolean sendBytes = mSerialPortManager.sendBytes(Utils.hexStr2bytes("A55801FB"));
            Log.i("onClick", "sendBytes: " + sendBytes);
        });

        mSerialPortManager.setOnSerialPortDataListener(new OnSerialPortDataListener() {
            @Override
            public void onDataReceived(byte[] bytes) {
                Log.i("SerialPortDataListener", "bytes111" + new String(bytes));
                setTemperature(bytes);
            }

            @Override
            public void onDataSent(byte[] bytes) {
                Log.i("SerialPortDataListener", "onDataSent222" + new String(bytes));
            }
        });
        llRight.setOnClickListener(this);
        llWrong.setOnClickListener(this);
    }

    @Override
    protected void initViewData() {

    }

    private void setTemperature(byte[] bytes) {
        if (serial.length() > 100) {
            serial = "";
        }
        try {
            String substring = Utils.byte2hex(bytes).substring(0, 22);
            String substring1 = substring.substring(8, 10);
            String substring2 = substring.substring(10, 12);
            int string = Utils.hexStringToAlgorism(substring1);
            int string1 = Utils.hexStringToAlgorism(substring2);
            float temperature = (string + 256 * string1) / 100;
            serial += temperature + "\n";
            runOnUiThread(() -> tvSerial.setText(serial));
        } catch (Exception e) {
            Log.e("Exception", e.getMessage());
        }
    }

    @SuppressLint("NonConstantResourceId")
    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.ll_right:
                state = 1;
                setIntentData();
                break;
            case R.id.ll_wrong:
                state = 2;
                setIntentData();
                break;
        }
    }

    public void setIntentData() {
        Intent intent = new Intent();
        intent.putExtra("name", name);
        intent.putExtra("state", state);
        intent.putExtra("position", position);
        setResult(Constants.resultCode, intent);
        finish();
    }
}
